/**
 * MachForm
 * 
 * © 2007–2025 Appnitro Software. All rights reserved.
 * 
 * This source code is proprietary and may not be copied, modified,
 * or distributed in any form without express written permission from Appnitro Software.
 * 
 * License information: https://www.machform.com/license-agreement/
 */
$(function(){
    
	//event handler for Google Sheets toggle checkbox
	$("#toggle_integration_gsheets").on('click',function(){
		$("#gsheets_toggle_wrapper").append("<div class='small_loader_box' style='float: right;margin-top: -8px'><img src='images/loader_small_grey.gif' /></div>");
		
		var integration_status = 0;
		if($(this).prop("checked") == true){
			integration_status = 1;
		}else{
			integration_status = 0;
		}

		var form_id 	= $(".integrations_settings").data("formid");
		var csrf_token  = $(".integrations_settings").data("csrftoken");

		//do the ajax call to change the integration status
		axios.post('change_integration_status.php', {
			form_id: form_id,
			integration_status: integration_status,
			csrf_token: csrf_token,
			integration_type: 'gsheets'
		})
		.then(function (response) {
			if(response.data.status == 'ok'){
				$("#gsheets_toggle_wrapper .small_loader_box").remove(); 
			}else{
				$("#gsheets_toggle_wrapper .small_loader_box").remove(); 
				Swal.fire({
					width: '30%',
					position: 'center',
					icon: 'error',
					title: 'Error. Unable to complete the task.',
					html: response.data,
					showConfirmButton: false,
					showCancelButton: true,
					cancelButtonText: 'Close',
					allowOutsideClick: true
				});
			}
		})
		.catch(function (error) {
			$("#gsheets_toggle_wrapper .small_loader_box").remove();
			Swal.fire({
				width: '30%',
				position: 'center',
				icon: 'error',
				title: 'Error. Unable to complete the task.',
				html: error,
				showConfirmButton: false,
				showCancelButton: true,
				cancelButtonText: 'Close',
				allowOutsideClick: true
			});
		});
		
		
	});

	//event handler for Google Sheets toggle checkbox
	$("#toggle_integration_gcal").on('click',function(){
		$("#gcal_toggle_wrapper").append("<div class='small_loader_box' style='float: right;margin-top: -8px'><img src='images/loader_small_grey.gif' /></div>");
		
		var integration_status = 0;
		if($(this).prop("checked") == true){
			integration_status = 1;
		}else{
			integration_status = 0;
		}

		var form_id 	= $(".integrations_settings").data("formid");
		var csrf_token  = $(".integrations_settings").data("csrftoken");

		//do the ajax call to change the integration status
		axios.post('change_integration_status.php', {
			form_id: form_id,
			integration_status: integration_status,
			csrf_token: csrf_token,
			integration_type: 'gcal'
		})
		.then(function (response) {
			if(response.data.status == 'ok'){
				$("#gcal_toggle_wrapper .small_loader_box").remove();
			}else{
				$("#gcal_toggle_wrapper .small_loader_box").remove();
				Swal.fire({
					width: '30%',
					position: 'center',
					icon: 'error',
					title: 'Error. Unable to complete the task.',
					html: response.data,
					showConfirmButton: false,
					showCancelButton: true,
					cancelButtonText: 'Close',
					allowOutsideClick: true
				});
			}
		})
		.catch(function (error) {
			$("#gcal_toggle_wrapper .small_loader_box").remove();
			Swal.fire({
				width: '30%',
				position: 'center',
				icon: 'error',
				title: 'Error. Unable to complete the task.',
				html: error,
				showConfirmButton: false,
				showCancelButton: true,
				cancelButtonText: 'Close',
				allowOutsideClick: true
			});
		});
		
		
	});
});